/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.ant;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.apache.catalina.ant.AbstractCatalinaTask;
import org.apache.tools.ant.BuildException;

public class JKStatusUpdateTask
extends AbstractCatalinaTask {
    private String worker = "lb";
    private String workerType = "lb";
    private int internalid = 0;
    private Integer lbRetries;
    private Integer lbRecovertime;
    private Boolean lbStickySession = Boolean.TRUE;
    private Boolean lbForceSession = Boolean.FALSE;
    private Integer workerLoadFactor;
    private String workerRedirect;
    private String workerClusterDomain;
    private Boolean workerDisabled = Boolean.FALSE;
    private Boolean workerStopped = Boolean.FALSE;
    private boolean isLBMode = true;
    private String workerLb;

    public JKStatusUpdateTask() {
        this.setUrl("http://localhost/status");
    }

    public int getInternalid() {
        return this.internalid;
    }

    public void setInternalid(int n) {
        this.internalid = n;
    }

    public Boolean getLbForceSession() {
        return this.lbForceSession;
    }

    public void setLbForceSession(Boolean bl) {
        this.lbForceSession = bl;
    }

    public Integer getLbRecovertime() {
        return this.lbRecovertime;
    }

    public void setLbRecovertime(Integer n) {
        this.lbRecovertime = n;
    }

    public Integer getLbRetries() {
        return this.lbRetries;
    }

    public void setLbRetries(Integer n) {
        this.lbRetries = n;
    }

    public Boolean getLbStickySession() {
        return this.lbStickySession;
    }

    public void setLbStickySession(Boolean bl) {
        this.lbStickySession = bl;
    }

    public String getWorker() {
        return this.worker;
    }

    public void setWorker(String string) {
        this.worker = string;
    }

    public String getWorkerType() {
        return this.workerType;
    }

    public void setWorkerType(String string) {
        this.workerType = string;
    }

    public String getWorkerLb() {
        return this.workerLb;
    }

    public void setWorkerLb(String string) {
        this.workerLb = string;
    }

    public String getWorkerClusterDomain() {
        return this.workerClusterDomain;
    }

    public void setWorkerClusterDomain(String string) {
        this.workerClusterDomain = string;
    }

    public Boolean getWorkerDisabled() {
        return this.workerDisabled;
    }

    public void setWorkerDisabled(Boolean bl) {
        this.workerDisabled = bl;
    }

    public Boolean getWorkerStopped() {
        return this.workerStopped;
    }

    public void setWorkerStopped(Boolean bl) {
        this.workerStopped = bl;
    }

    public Integer getWorkerLoadFactor() {
        return this.workerLoadFactor;
    }

    public void setWorkerLoadFactor(Integer n) {
        this.workerLoadFactor = n;
    }

    public String getWorkerRedirect() {
        return this.workerRedirect;
    }

    public void setWorkerRedirect(String string) {
        this.workerRedirect = string;
    }

    @Override
    public void execute() throws BuildException {
        super.execute();
        this.checkParameter();
        StringBuilder stringBuilder = this.createLink();
        this.execute(stringBuilder.toString(), null, null, -1L);
    }

    private StringBuilder createLink() {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            stringBuilder.append("?cmd=update&mime=txt");
            stringBuilder.append("&w=");
            stringBuilder.append(URLEncoder.encode(this.worker, this.getCharset()));
            if (this.isLBMode) {
                if (this.lbRetries != null) {
                    stringBuilder.append("&lr=");
                    stringBuilder.append(this.lbRetries);
                }
                if (this.lbRecovertime != null) {
                    stringBuilder.append("&lt=");
                    stringBuilder.append(this.lbRecovertime);
                }
                if (this.lbStickySession != null) {
                    stringBuilder.append("&ls=");
                    stringBuilder.append(this.lbStickySession);
                }
                if (this.lbForceSession != null) {
                    stringBuilder.append("&lf=");
                    stringBuilder.append(this.lbForceSession);
                }
            } else {
                if (this.workerLb != null) {
                    stringBuilder.append("&l=");
                    stringBuilder.append(URLEncoder.encode(this.workerLb, this.getCharset()));
                }
                if (this.workerLoadFactor != null) {
                    stringBuilder.append("&wf=");
                    stringBuilder.append(this.workerLoadFactor);
                }
                if (this.workerDisabled != null) {
                    stringBuilder.append("&wd=");
                    stringBuilder.append(this.workerDisabled);
                }
                if (this.workerStopped != null) {
                    stringBuilder.append("&ws=");
                    stringBuilder.append(this.workerStopped);
                }
                if (this.workerRedirect != null) {
                    stringBuilder.append("&wr=");
                }
                if (this.workerClusterDomain != null) {
                    stringBuilder.append("&wc=");
                    stringBuilder.append(URLEncoder.encode(this.workerClusterDomain, this.getCharset()));
                }
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new BuildException("Invalid 'charset' attribute: " + this.getCharset());
        }
        return stringBuilder;
    }

    protected void checkParameter() {
        if (this.worker == null) {
            throw new BuildException("Must specify 'worker' attribute");
        }
        if (this.workerType == null) {
            throw new BuildException("Must specify 'workerType' attribute");
        }
        if ("lb".equals(this.workerType)) {
            if (this.lbRecovertime == null && this.lbRetries == null) {
                throw new BuildException("Must specify at a lb worker either 'lbRecovertime' or'lbRetries' attribute");
            }
            if (this.lbStickySession == null || this.lbForceSession == null) {
                throw new BuildException("Must specify at a lb worker either'lbStickySession' and 'lbForceSession' attribute");
            }
            if (null != this.lbRecovertime && 60 < this.lbRecovertime) {
                throw new BuildException("The 'lbRecovertime' must be greater than 59");
            }
            if (null != this.lbRetries && 1 < this.lbRetries) {
                throw new BuildException("The 'lbRetries' must be greater than 1");
            }
            this.isLBMode = true;
        } else if ("worker".equals(this.workerType)) {
            if (this.workerDisabled == null) {
                throw new BuildException("Must specify at a node worker 'workerDisabled' attribute");
            }
            if (this.workerStopped == null) {
                throw new BuildException("Must specify at a node worker 'workerStopped' attribute");
            }
            if (this.workerLoadFactor == null) {
                throw new BuildException("Must specify at a node worker 'workerLoadFactor' attribute");
            }
            if (this.workerClusterDomain == null) {
                throw new BuildException("Must specify at a node worker 'workerClusterDomain' attribute");
            }
            if (this.workerRedirect == null) {
                throw new BuildException("Must specify at a node worker 'workerRedirect' attribute");
            }
            if (this.workerLb == null) {
                throw new BuildException("Must specify 'workerLb' attribute");
            }
            if (this.workerLoadFactor < 1) {
                throw new BuildException("The 'workerLoadFactor' must be greater or equal 1");
            }
            this.isLBMode = false;
        } else {
            throw new BuildException("Only 'lb' and 'worker' supported as workerType attribute");
        }
    }
}

