/*
 * Decompiled with CFR 0.152.
 */
package j2html.tags;

import j2html.Config;
import j2html.rendering.FlatHtml;
import j2html.rendering.HtmlBuilder;
import java.io.IOException;
import java.io.UncheckedIOException;

public interface Renderable {
    default public <T extends Appendable> T render(HtmlBuilder<T> builder, Object model) throws IOException {
        this.renderModel(builder, model);
        return builder.output();
    }

    default public <T extends Appendable> T render(HtmlBuilder<T> builder) throws IOException {
        return this.render(builder, null);
    }

    default public String render() {
        try {
            return this.render(FlatHtml.into(new StringBuilder(), Config.global())).toString();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Deprecated
    default public void render(Appendable writer) throws IOException {
        if (writer instanceof HtmlBuilder) {
            this.render((HtmlBuilder)writer);
        } else {
            this.render(FlatHtml.into(writer, Config.global()));
        }
    }

    @Deprecated
    default public void renderModel(Appendable writer, Object model) throws IOException {
        throw new RuntimeException("Renderable.renderModel(Appendable writer, Object model) has been deprecated.  Please use Renderable.render(HtmlBuilder<T> builder, Object model) instead.");
    }
}

