/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.functional.impl;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.infinispan.commons.util.Experimental;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.Listeners;
import org.infinispan.functional.impl.EntryViews;
import org.infinispan.functional.impl.FunctionalNotifier;
import org.infinispan.metadata.Metadata;

@Experimental
public final class FunctionalNotifierImpl<K, V>
implements FunctionalNotifier<K, V> {
    final List<Consumer<EntryView.ReadEntryView<K, V>>> onCreates = new CopyOnWriteArrayList<Consumer<EntryView.ReadEntryView<K, V>>>();
    final List<BiConsumer<EntryView.ReadEntryView<K, V>, EntryView.ReadEntryView<K, V>>> onModifies = new CopyOnWriteArrayList<BiConsumer<EntryView.ReadEntryView<K, V>, EntryView.ReadEntryView<K, V>>>();
    final List<Consumer<EntryView.ReadEntryView<K, V>>> onRemoves = new CopyOnWriteArrayList<Consumer<EntryView.ReadEntryView<K, V>>>();
    final List<Consumer<EntryView.ReadEntryView<K, V>>> onWrites = new CopyOnWriteArrayList<Consumer<EntryView.ReadEntryView<K, V>>>();
    final List<Listeners.ReadWriteListeners.ReadWriteListener<K, V>> rwListeners = new CopyOnWriteArrayList<Listeners.ReadWriteListeners.ReadWriteListener<K, V>>();
    final List<Listeners.WriteListeners.WriteListener<K, V>> writeListeners = new CopyOnWriteArrayList<Listeners.WriteListeners.WriteListener<K, V>>();

    @Override
    public AutoCloseable add(Listeners.WriteListeners.WriteListener<K, V> l) {
        this.writeListeners.add(l);
        return new ListenerCloseable<Listeners.WriteListeners.WriteListener<K, V>>(l, this.writeListeners);
    }

    @Override
    public AutoCloseable add(Listeners.ReadWriteListeners.ReadWriteListener<K, V> l) {
        this.rwListeners.add(l);
        return new ListenerCloseable<Listeners.ReadWriteListeners.ReadWriteListener<K, V>>(l, this.rwListeners);
    }

    @Override
    public AutoCloseable onCreate(Consumer<EntryView.ReadEntryView<K, V>> f) {
        this.onCreates.add(f);
        return new ListenerCloseable<Consumer<EntryView.ReadEntryView<K, V>>>(f, this.onCreates);
    }

    @Override
    public AutoCloseable onModify(BiConsumer<EntryView.ReadEntryView<K, V>, EntryView.ReadEntryView<K, V>> f) {
        this.onModifies.add(f);
        return new ListenerCloseable<BiConsumer<EntryView.ReadEntryView<K, V>, EntryView.ReadEntryView<K, V>>>(f, this.onModifies);
    }

    @Override
    public AutoCloseable onRemove(Consumer<EntryView.ReadEntryView<K, V>> f) {
        this.onRemoves.add(f);
        return new ListenerCloseable<Consumer<EntryView.ReadEntryView<K, V>>>(f, this.onRemoves);
    }

    @Override
    public AutoCloseable onWrite(Consumer<EntryView.ReadEntryView<K, V>> f) {
        this.onWrites.add(f);
        return new ListenerCloseable<Consumer<EntryView.ReadEntryView<K, V>>>(f, this.onWrites);
    }

    @Override
    public void notifyOnCreate(CacheEntry entry) {
        if (!this.onCreates.isEmpty() || !this.rwListeners.isEmpty()) {
            EntryView.ReadEntryView created = EntryViews.readOnly(entry);
            this.onCreates.forEach(c -> c.accept(created));
            this.rwListeners.forEach(rwl -> rwl.onCreate(created));
        }
    }

    @Override
    public void notifyOnModify(CacheEntry<K, V> entry, V previousValue, Metadata previousMetadata) {
        if (!this.onModifies.isEmpty() || !this.rwListeners.isEmpty()) {
            EntryView.ReadEntryView before = EntryViews.readOnly(entry.getKey(), previousValue, previousMetadata);
            EntryView.ReadEntryView after = EntryViews.readOnly(entry);
            this.onModifies.forEach(c -> c.accept(before, after));
            this.rwListeners.forEach(rwl -> rwl.onModify(before, after));
        }
    }

    @Override
    public void notifyOnRemove(EntryView.ReadEntryView<K, V> removed) {
        this.onRemoves.forEach(c -> c.accept(removed));
        this.rwListeners.forEach(rwl -> rwl.onRemove(removed));
    }

    @Override
    public void notifyOnWrite(CacheEntry<K, V> entry) {
        if (!this.onWrites.isEmpty() || !this.writeListeners.isEmpty()) {
            EntryView.ReadEntryView wrote = EntryViews.readOnly(entry);
            this.onWrites.forEach(c -> c.accept(wrote));
            this.writeListeners.forEach(wl -> wl.onWrite(wrote));
        }
    }

    @Override
    public void notifyOnWriteRemove(K key) {
        if (!this.onWrites.isEmpty() || !this.writeListeners.isEmpty()) {
            EntryView.ReadEntryView wrote = EntryViews.noValue(key);
            this.onWrites.forEach(c -> c.accept(wrote));
            this.writeListeners.forEach(wl -> wl.onWrite(wrote));
        }
    }

    private static final class ListenerCloseable<T>
    implements AutoCloseable {
        final T f;
        final List<T> list;

        private ListenerCloseable(T f, List<T> list) {
            this.f = f;
            this.list = list;
        }

        @Override
        public void close() throws Exception {
            this.list.remove(this.f);
        }
    }
}

