/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oid4vc.issuance.mappers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.ProtocolMapper;
import org.keycloak.protocol.oid4vc.issuance.mappers.OID4VCMapper;
import org.keycloak.protocol.oid4vc.model.VerifiableCredential;
import org.keycloak.provider.ProviderConfigProperty;

public class OID4VCStaticClaimMapper
extends OID4VCMapper {
    public static final String MAPPER_ID = "oid4vc-static-claim-mapper";
    public static final String SUBJECT_PROPERTY_CONFIG_KEY = "subjectProperty";
    public static final String STATIC_CLAIM_KEY = "staticValue";
    private static final List<ProviderConfigProperty> CONFIG_PROPERTIES = new ArrayList<ProviderConfigProperty>();

    @Override
    protected List<ProviderConfigProperty> getIndividualConfigProperties() {
        return CONFIG_PROPERTIES;
    }

    @Override
    public void setClaimsForCredential(VerifiableCredential verifiableCredential, UserSessionModel userSessionModel) {
    }

    @Override
    public void setClaimsForSubject(Map<String, Object> claims, UserSessionModel userSessionModel) {
        String propertyName = (String)this.mapperModel.getConfig().get(SUBJECT_PROPERTY_CONFIG_KEY);
        String staticValue = (String)this.mapperModel.getConfig().get(STATIC_CLAIM_KEY);
        claims.put(propertyName, staticValue);
    }

    public String getDisplayType() {
        return "Static Claim Mapper";
    }

    public String getHelpText() {
        return "Allows to set static values for the credential subject.";
    }

    public ProtocolMapper create(KeycloakSession session) {
        return new OID4VCStaticClaimMapper();
    }

    public String getId() {
        return MAPPER_ID;
    }

    static {
        ProviderConfigProperty subjectPropertyNameConfig = new ProviderConfigProperty();
        subjectPropertyNameConfig.setName(SUBJECT_PROPERTY_CONFIG_KEY);
        subjectPropertyNameConfig.setLabel("Static Claim Property Name");
        subjectPropertyNameConfig.setHelpText("Name of the property to contain the static value.");
        subjectPropertyNameConfig.setType("String");
        CONFIG_PROPERTIES.add(subjectPropertyNameConfig);
        ProviderConfigProperty claimValueConfig = new ProviderConfigProperty();
        claimValueConfig.setName(STATIC_CLAIM_KEY);
        claimValueConfig.setLabel("Static Claim Value");
        claimValueConfig.setHelpText("Value to be set for the property.");
        claimValueConfig.setType("String");
        CONFIG_PROPERTIES.add(claimValueConfig);
    }
}

