/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.runtime.tracing;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.semconv.ServiceAttributes;
import io.opentelemetry.semconv.incubating.WebengineIncubatingAttributes;
import io.quarkus.opentelemetry.runtime.tracing.DelayedAttributes;
import io.quarkus.runtime.annotations.Recorder;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;

@Recorder
public class TracerRecorder {
    public static final Set<String> dropNonApplicationUriTargets = new HashSet<String>();
    public static final Set<String> dropStaticResourceTargets = new HashSet<String>();

    public Supplier<DelayedAttributes> delayedAttributes(final String quarkusVersion, final String serviceName, final String serviceVersion) {
        return new Supplier<DelayedAttributes>(){

            @Override
            public DelayedAttributes get() {
                DelayedAttributes result = new DelayedAttributes();
                result.setAttributesDelegate(Resource.getDefault().merge(Resource.create((Attributes)Attributes.of((AttributeKey)ServiceAttributes.SERVICE_NAME, (Object)serviceName, (AttributeKey)ServiceAttributes.SERVICE_VERSION, (Object)serviceVersion, (AttributeKey)WebengineIncubatingAttributes.WEBENGINE_NAME, (Object)"Quarkus", (AttributeKey)WebengineIncubatingAttributes.WEBENGINE_VERSION, (Object)quarkusVersion))).getAttributes());
                return result;
            }
        };
    }

    public void setupSampler(List<String> dropNonApplicationUris, List<String> dropStaticResources) {
        dropNonApplicationUriTargets.addAll(dropNonApplicationUris);
        dropStaticResourceTargets.addAll(dropStaticResources);
    }
}

